// This script only applies to this instance of the Atlas.
// Please also check code indicated with "@instanceonly" outside this file.
// TODO: Avoid having instance-only code inside the main scripts to make updating easier.

const prodDomain = "canvas.mariusdavid.fr"
window.prodDomain = prodDomain

const instanceId = "canvas2024"
window.instanceId = instanceId

const instanceSubreddit = null
window.instanceSubreddit = instanceSubreddit

const instanceRepo = null
window.instanceRepo = instanceRepo

const pageTitle = "2024 Fediverse canvas Atlas"
window.pageTitle = pageTitle

const canvasSize = {
	x: 1000,
	y: 500
}
window.canvasSize = canvasSize

const canvasOffset = {
	x: 0,
	y: 0
}
window.canvasOffset = canvasOffset

const canvasCenter = {
	x: canvasSize.x/2 + canvasOffset.x,
	y: canvasSize.y/2 + canvasOffset.y
}
window.canvasCenter = canvasCenter

const variationsConfig = {
	default: {
		name: "canvas",
		code: "",
		default: 0,
		drawablePeriods: [0, 0],
		drawableRegions: [
			[[0, 0], [0, 0, 999, 499]]
		],
		versions: [
			{
				timestamp: "Final",
				url: "./_img/fedicanvas/final.png",
			}
		],
		icon: '<svg width="14" height="14" version="1.1" viewBox="0 0 14 14" xmlns="http://www.w3.org/2000/svg" fill="currentColor"><g><rect y="8" width="6" height="6"/><rect x="6" width="8" height="8"/></g></svg>'

	}
}
window.variationsConfig = variationsConfig

let defaultVariation = 'default'
window.defaultVariation = defaultVariation

let defaultPeriod = variationsConfig[defaultVariation].default
window.defaultPeriod = defaultPeriod

const useNumericalId = true
window.useNumericalId = useNumericalId

const externalLinksConfig = [
	{
		name: "Lemmy",
		id: "lemmy",
		generateLink: (link) => {
			if (link.startsWith("@")) {
				return "https://" + link + "/"
			} else if (link.startsWith("!") && link.indexOf("@") !== -1) {
				let community = link.substring(1).split("@")[0]
				let host = link.split("@")[1]
				return "https://" + host + "/c/" + community
			} else {
				return link
			}
		},
		listingClass: "bi-envelope", //TODO: canvas adaptation: actually put a lemmy icon
		generateListingName: (link) => link,
		placeholder: "!community@example.org",
		configureInputField: (inputField) => {
			inputField.placeholder = "!community@example.com"
			inputField.title = "Lemmy link using the !community@example.com format, a Lemmy domain using the @example.com format or a post with it’s url"
		},
	},
	{
		name: "Matrix",
		id: "matrix",
		generateLink: (link) => "https://matrix.to/#/" + link,
		listingClass: "bi-chat-dots", //TODO: canvas adaptation: actually put a Matrix, if any exist
		generateListingName: (link) => link,
		placeholder: "#example:example.com",
		configureInputField: (inputField) => {
			inputField.placeholder = "#example:example.com"
			inputField.title = "Link to a Matrix room or space, in the form of #example:example.com"
			inputField.pattern = "#.*:.*"
		}
	},
	{
		name: "Website",
		id: "website",
		generateLink: (link) => link,
		listingClass: "bi-globe",
		generateListingName: (link) => {
			try {
				const urlObject = new URL(link)
				return urlObject.hostname.replace(/^www./, "")
			} catch (e) {
				return "Website"
			}
		},
		placeholder: "https://example.org",
		configureInputField: (inputField) => {
			inputField.type = "url"
			inputField.placeholder = "https://example.com"
			inputField.pattern = "https?://.*"
			inputField.title = "Website URL using the http:// or https:// protocol"
		}
	},
	{
		name: "Discord",
		id: "discord",
		generateLink: (link) => "https://discord.gg/" + link,
		generateListingName: (link) => link,
		listingClass: "bi-discord",
		editorPrefix: "discord.gg/",
		placeholder: "r/example",
		configureInputField: (inputField) => {
			inputField.placeholder = "pJkm23b2nA"
		},
		extractId: (content) => {
			const discordPattern = /^(?:(?:https?:\/\/)?(?:www\.)?(?:(?:discord)?\.?gg|discord(?:app)?\.com\/invite)\/)?([^\s/]+?)(?=\b)$/
			id = content.trim().match(discordPattern)?.[1]
			if (id) {
				return id;
			}
			return content;
		}
	},
	{
		name: "Subreddit",
		id: "subreddit",
		generateLink: (link) => "https://reddit.com/r/" + link,
		listingClass: "bi-reddit",
		generateListingName: (link) => "r/" + link,
		editorPrefix: "reddit.com/",
		placeholder: "pJkm23b2nA",
		configureInputField: (inputField) => {
			inputField.placeholder = "r/example"
			inputField.pattern = "^r\/[A-Za-z0-9][A-Za-z0-9_]{1,50}$"
			inputField.title = "Subreddit in format of r/example"
			inputField.minLength = "4"
			inputField.maxLength = "50"
		},
		extractId: (content) => {
			const subredditPattern = /^(?:(?:(?:(?:(?:https?:\/\/)?(?:(?:www|old|new|np)\.)?)?reddit\.com)?\/)?[rR]\/)?([A-Za-z0-9][A-Za-z0-9_]{1,20})(?:\/[^" ]*)*$/
			id = content.trim().match(subredditPattern)?.[1]
			if (id) {
				return id;
			}
			return content;
		},
		formatIdInEditor: (content) => {
			if (content != "") {
				return "r/" + content;
			}
			return "";
		}

	}
];

console.info(`%cThe 2023 r/place Atlas
%cCopyright (c) 2017 Roland Rytz <roland@draemm.li>
Copyright (c) 2023 Place Atlas Initiative and contributors
Copyright (c) 2024 Fediverse canvas atlas contributors
Licensed under AGPL-3.0 (https://2023.place-atlas.stefanocoding.me/license.txt)

https://2023.place-atlas.stefanocoding.me/
https://discord.gg/pJkm23b2nA
https://reddit.com/r/placeAtlas2023
https://github.com/placeAtlas/atlas-2023

To get the image of the canvas, use downloadCanvas().
`, 'font-size: 150%; line-height: 150%', '')
