{
  inputs = {
    utils.url = "github:numtide/flake-utils";
  };
  outputs = { self, nixpkgs, utils }: 
	let
		result = utils.lib.eachDefaultSystem (system:
			let
				pkgs = nixpkgs.legacyPackages.${system};
			in
			{
				packages = rec {
					website = pkgs.stdenvNoCC.mkDerivation {
						pname = "fediverse-canvas-atlas-website";
						version = "git-" + (self.shortRev or "dirty");

						dontUnpack = true;

						installPhase = ''
							mkdir -p $out
							cp -r ${./.}/web/* $out/
							${pkgs.python3}/bin/python ${./.}/tools/merge_data.py ${./.}/entries $out/atlas.json
							rm $out/about.html

							mkdir $out/nix-support
							echo ${self.shortRev} > $out/revision
              echo "doc manual $out" >> $out/nix-support/hydra-build-products
						'';
					};
					default = website;
				};
			}
  	);
	in
		result // {
			hydraJobs.x86_64-linux = {
				website = result.packages.x86_64-linux.website;
			};
		};
}