# Mostly copied from https://gitlab.com/simple-nixos-mailserver/nixos-mailserver/-/blob/master/.hydra/declarative-jobsets.nix?ref_type=heads

{ nixpkgs, pulls, ... }:

let
  pkgs = import nixpkgs {};

  prs = builtins.fromJSON (builtins.readFile pulls);
  prJobsets =  pkgs.lib.mapAttrs (num: info:
    { enabled = 1;
      hidden = false;
      description = "PR ${num}: ${info.title}";
      checkinterval = 60;
      schedulingshares = 20;
      enableemail = false;
      emailoverride = "";
      keepnr = 2;
      type = 1;
      flake = "gitlab:marius851000/fediverse-canvas-atlas-2024/merge-requests/${info.iid}/head?host=git.sc07.company";
    }
  ) prs;
  /*mkFlakeJobset = branch: {
    description = "Build ${branch} branch of Simple NixOS MailServer";
    checkinterval = "60";
    enabled = "1";
    schedulingshares = 100;
    enableemail = false;
    emailoverride = "";
    keepnr = 3;
    hidden = false;
    type = 1;
    flake = "gitlab:simple-nixos-mailserver/nixos-mailserver/${branch}";
  };*/

  desc = prJobsets/* // {
    "master" = mkFlakeJobset "master";
    "nixos-23.11" = mkFlakeJobset "nixos-23.11";
    "nixos-24.05" = mkFlakeJobset "nixos-24.05";
  }*/;

  log = {
    pulls = prs;
    jobsets = desc;
  };

in {
  jobsets = pkgs.runCommand "spec-jobsets.json" {} ''
    cat >$out <<EOF
    ${builtins.toJSON desc}
    EOF
    # This is to get nice .jobsets build logs on Hydra
    cat >tmp <<EOF
    ${builtins.toJSON log}
    EOF
    ${pkgs.jq}/bin/jq . tmp
  '';
}
