import { IBroadcastable } from "..";
import { b64, ub64 } from "../utils";

export class UserUnbanEvent implements IBroadcastable {
  private _sub: string;

  constructor(sub: string) {
    this._sub = sub;
  }

  static getChannel() {
    return "user_unban";
  }

  static fromString(data: string): UserUnbanEvent {
    return new this(ub64(data));
  }

  get sub() {
    return this._sub;
  }

  getChannel() {
    return UserUnbanEvent.getChannel();
  }

  getMessage() {
    return b64(this._sub);
  }
}
