import { IBroadcastable } from "..";
import { b64, ub64 } from "../utils";

export class UserBanEvent implements IBroadcastable {
  private _sub: string;
  private _expiresAt: Date;
  private _public_reason?: string;

  constructor(sub: string, expiresAt: Date, public_reason?: string) {
    this._sub = sub;
    this._expiresAt = expiresAt;
    this._public_reason = public_reason;
  }

  static getChannel() {
    return "user_ban";
  }

  static fromString(data: string): UserBanEvent {
    const [sub, expiresAt, public_reason] = data.split(":");

    return new this(
      ub64(sub),
      new Date(ub64(expiresAt)),
      public_reason === "null" ? undefined : ub64(public_reason)
    );
  }

  get sub() {
    return this._sub;
  }

  get expiresAt() {
    return this._expiresAt;
  }

  get public_reason() {
    return this._public_reason;
  }

  getChannel() {
    return UserBanEvent.getChannel();
  }

  getMessage() {
    return [
      b64(this._sub),
      b64(this._expiresAt.toISOString()),
      this._public_reason ? b64(this._public_reason) : "null",
    ].join(":");
  }
}
