import { IBroadcastable } from ".";
import { b64, ub64 } from "../utils";

export class InstanceUnbanEvent implements IBroadcastable {
  private _hostname: string;

  constructor(hostname: string) {
    this._hostname = hostname;
  }

  static getChannel() {
    return "instance_unban";
  }

  static fromString(data: string): InstanceUnbanEvent {
    return new this(ub64(data));
  }

  get hostname() {
    return this._hostname;
  }

  getChannel() {
    return InstanceUnbanEvent.getChannel();
  }

  getMessage() {
    return b64(this._hostname);
  }
}
