import { IBroadcastable } from ".";
import { b64, ub64 } from "../utils";

export class InstanceBanEvent implements IBroadcastable {
  private _hostname: string;
  private _expiresAt: Date;
  private _public_reason?: string;

  constructor(hostname: string, expiresAt: Date, public_reason?: string) {
    this._hostname = hostname;
    this._expiresAt = expiresAt;
    this._public_reason = public_reason;
  }

  static getChannel() {
    return "instance_ban";
  }

  static fromString(data: string): InstanceBanEvent {
    const [hostname, expiresAt, public_reason] = data.split(":");

    return new this(
      ub64(hostname),
      new Date(ub64(expiresAt)),
      public_reason === "null" ? undefined : ub64(public_reason)
    );
  }

  get hostname() {
    return this._hostname;
  }

  get expiresAt() {
    return this._expiresAt;
  }

  get public_reason() {
    return this._public_reason;
  }

  getChannel() {
    return InstanceBanEvent.getChannel();
  }

  getMessage() {
    return [
      b64(this._hostname),
      b64(this._expiresAt.toISOString()),
      this._public_reason ? b64(this._public_reason) : "null",
    ].join(":");
  }
}
