import React from "react";
import ReactDOM from "react-dom/client";
import App from "./App.tsx";
import "./index.css";
import { CssBaseline, ThemeProvider, createTheme } from "@mui/material";
import { RouterProvider, createBrowserRouter } from "react-router-dom";
import { LoginPage } from "./Login/Login.tsx";
import { InteractionPage } from "./Interaction/InteractionPage.tsx";
import { LogoutPage } from "./Logout/Logout.tsx";
import { HandoffPage } from "./Handoff/HandoffPage.tsx";
import { ServerSideContext } from "./lib/ServerSideData.tsx";

const theme = createTheme({ palette: { mode: "dark" } });
const router = createBrowserRouter([
  {
    path: "/",
    element: <App />,
  },
  {
    path: "/login",
    element: <LoginPage />,
  },
  {
    path: "/logout",
    element: <LogoutPage />,
  },
  {
    path: "/interaction/:id",
    element: <InteractionPage />,
  },
  {
    path: "/handoff/:id",
    element: <HandoffPage />,
  },
]);

ReactDOM.createRoot(document.getElementById("root")!).render(
  <React.StrictMode>
    <ServerSideContext>
      <ThemeProvider theme={theme}>
        <CssBaseline />
        <RouterProvider router={router} />
      </ThemeProvider>
    </ServerSideContext>
  </React.StrictMode>
);
