import {
  createContext,
  PropsWithChildren,
  useContext,
  useEffect,
  useState,
} from "react";

const context = createContext<any>(undefined);

export const useSSData = <T,>() => useContext<T>(context);

export const ServerSideContext = ({ children }: PropsWithChildren) => {
  if (import.meta.env.PROD) {
    const value: any = document.getElementById("ss-data")
      ? JSON.parse(document.getElementById("ss-data")!.innerText)
      : undefined;
    return <context.Provider value={value}>{children}</context.Provider>;
  }

  // eslint-disable-next-line react-hooks/rules-of-hooks
  const [ready, setReady] = useState(false);
  // eslint-disable-next-line react-hooks/rules-of-hooks
  const [value, setValue] = useState<any>(undefined);

  // eslint-disable-next-line react-hooks/rules-of-hooks
  useEffect(() => {
    if (import.meta.env.DEV) {
      fetch("/_dev/ssdata")
        .then((a) => a.json())
        .then((data) => {
          setValue(data);
          setReady(true);
        });
    }
  }, []);

  return (
    <context.Provider value={value}>
      {ready ? children : <>Dev: waiting for server data</>}
    </context.Provider>
  );
};
