import { Box, Card, CardContent } from "@mui/material";
import { PropsWithChildren } from "react";

export const PageWrapper = ({ children }: PropsWithChildren) => {
  return (
    <Box
      sx={{
        display: "flex",
        justifyContent: "center",
        alignItems: "center",
        p: 5,
      }}
    >
      <Box sx={{ width: "min(400px,90%)" }}>
        <Card>
          <CardContent>{children}</CardContent>
        </Card>
      </Box>
    </Box>
  );
};
