import {
  Alert,
  Box,
  CircularProgress,
  Divider,
  Link,
  Typography,
} from "@mui/material";
import { PageWrapper } from "../PageWrapper";
import { LoadingButton } from "@mui/lab";
import { useEffect, useState } from "react";

export const LogoutPage = () => {
  const [loading, setLoading] = useState(false);
  const [state, setState] = useState<
    "logged-in" | "now-logged-out" | "never-logged-in"
  >();

  useEffect(() => {
    fetch("/api/v1/whoami", {
      credentials: "include",
    })
      .then((a) => a.json())
      .then((data) => {
        if ("error" in data) {
          setState("never-logged-in");
        } else {
          setState("logged-in");
        }
      });
  }, []);

  const doLogout = () => {
    setLoading(true);

    fetch("/api/v1/logout", {
      method: "POST",
      credentials: "include",
    })
      .then((a) => a.json())
      .then((data) => {
        if (data.success) {
          setState("now-logged-out");
        } else {
          alert("Error: " + data.error);
        }
      })
      .finally(() => {
        setLoading(false);
      });
  };

  return (
    <PageWrapper>
      <Typography variant="h5" component="div" sx={{ mb: 1 }}>
        Logout
      </Typography>
      {state === undefined && (
        <Box
          sx={{
            width: "100%",
            display: "flex",
            justifyContent: "center",
            alignItems: "center",
          }}
        >
          <CircularProgress />
        </Box>
      )}
      {state === "never-logged-in" && (
        <Alert severity="info">
          <b>You are not logged in</b>
        </Alert>
      )}
      {state === "now-logged-out" && (
        <Alert severity="success">
          <b>You are now logged out!</b>
        </Alert>
      )}
      {state === "logged-in" && (
        <>
          <Typography>Are you sure you want to logout?</Typography>
          <LoadingButton
            loading={loading}
            onClick={doLogout}
            variant="contained"
            sx={{ mt: 1 }}
          >
            Logout
          </LoadingButton>
        </>
      )}
      <Divider sx={{ my: 1 }} />
      <Link href="/">Go Home</Link>
    </PageWrapper>
  );
};
