import { Box, IconButton, Stack, SxProps, Typography } from "@mui/material";
import LogoutIcon from "@mui/icons-material/Logout";

interface IProfile {
  /**
   * username@hostname.tld
   * @example grant@grants.cafe
   */
  sub: string;

  /**
   * Display name from AP actor
   */
  name?: string;

  /**
   * How the instance formats the name (capitalization)
   */
  preferred_username?: string;

  /**
   * HTML URL to profile page
   */
  profile?: string;

  /**
   * URL to profile picture
   */
  picture?: string;
}

interface IInstance {
  software: {
    name: string;
    version: string;
    logo_uri?: string;
    repository?: string;
    homepage?: string;
  };
  instance: {
    /**
     * Untrusted URL
     */
    logo_uri?: string;
    /**
     * Untrusted URL
     */
    banner_uri?: string;
    name?: string;
  };
}

export const UserInfoCard = ({
  user,
  sx,
}: {
  user: IProfile & { instance?: IInstance; handle: `${string}@${string}` };
  sx?: SxProps;
}) => {
  const [username, instance] = user.handle.split("@");

  return (
    <Box
      sx={{
        border: "1px solid rgba(255,255,255,0.15)",
        borderRadius: "5px",
        p: 1,
        ...sx,
      }}
    >
      <Stack direction="row" gap={1} sx={{ alignItems: "center" }}>
        <Box
          sx={{
            height: "32px",
            width: "32px",
            backgroundColor: "rgba(255,255,255,0.25)",
            borderRadius: "5px",
            overflow: "hidden",
            display: "flex",
            justifyContent: "center",
            alignItems: "center",
            ...(user.picture && {
              backgroundImage: `url(${user.picture})`,
              backgroundPosition: "center",
              backgroundSize: "cover",
            }),
          }}
        >
          {!user.picture && "?"}
        </Box>
        <Stack direction="column" sx={{ flexGrow: 1 }}>
          <Typography>@{username}</Typography>
          <Typography variant="caption" color="text.secondary">
            @{instance}
          </Typography>
        </Stack>
        <Stack direction="row" gap={0.5}>
          <IconButton href={`/logout`}>
            <LogoutIcon fontSize="inherit" />
          </IconButton>
        </Stack>
      </Stack>
    </Box>
  );
};
