import { Box, IconButton, Stack, SxProps, Typography } from "@mui/material";
import { IOIDC_Client } from "../types/oidc";
import LanguageIcon from "@mui/icons-material/Language";
import { Link } from "react-router-dom";

export const ClientDetailsCard = ({
  client,
  sx,
}: {
  client: IOIDC_Client;
  sx?: SxProps;
}) => {
  return (
    <Box
      sx={{
        border: "1px solid rgba(255,255,255,0.15)",
        borderRadius: "5px",
        p: 1,
        ...sx,
      }}
    >
      <Stack direction="row" gap={1} sx={{ alignItems: "center" }}>
        <Box
          sx={{
            height: "32px",
            width: "32px",
            backgroundColor: "rgba(255,255,255,0.25)",
            borderRadius: "5px",
            overflow: "hidden",
            display: "flex",
            justifyContent: "center",
            alignItems: "center",
            ...(client.logoUri && {
              backgroundImage: `url(${client.logoUri})`,
              backgroundPosition: "center",
              backgroundSize: "cover",
            }),
          }}
        >
          ?
        </Box>
        <Stack direction="column" sx={{ flexGrow: 1 }}>
          <Typography>{client.clientName || "No Name"}</Typography>
          <Stack direction="row" gap={0.5}>
            {client.tosUri && (
              <Typography variant="caption" color="text.secondary">
                <Link to={client.tosUri} style={{ color: "inherit" }}>
                  Terms of Service
                </Link>
              </Typography>
            )}
            {client.policyUri && (
              <Typography variant="caption" color="text.secondary">
                <Link to={client.policyUri} style={{ color: "inherit" }}>
                  Privacy Policy
                </Link>
              </Typography>
            )}
          </Stack>
        </Stack>
        <Stack direction="row" gap={0.5}>
          {client.clientUri && (
            <IconButton href={client.clientUri} target="_blank">
              <LanguageIcon fontSize="inherit" />
            </IconButton>
          )}
        </Stack>
      </Stack>
    </Box>
  );
};
