import {
  Avatar,
  Box,
  CircularProgress,
  Divider,
  IconButton,
  Link,
  Menu,
  MenuItem,
  Tooltip,
  Typography,
} from "@mui/material";
import "./App.css";
import React, { useEffect, useState } from "react";
import { PageWrapper } from "./PageWrapper";
import { api } from "./lib/utils";
import { DocLinks } from "./lib/DocLinks";

const UserInfo = () => {
  const [avatarEl, setAvatarEl] = useState<null | HTMLElement>(null);
  const [whoami, setWhoami] = useState<{ sub: string }>();
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    api("/api/v1/whoami")
      .then(({ data }) => {
        setWhoami("error" in data ? undefined : data);
      })
      .catch(() => {
        // TODO: error handle
      })
      .finally(() => {
        setLoading(false);
      });
  }, []);

  const openMenu = (ev: React.MouseEvent<HTMLElement>) => {
    setAvatarEl(ev.currentTarget);
  };

  return (
    <>
      {loading && <CircularProgress size="2rem" />}
      {!loading && (
        <Tooltip title="Session Info">
          <IconButton onClick={openMenu} sx={{ p: 0 }}>
            {/* TODO: avatar endpoint */}
            <Avatar alt={whoami?.sub} src="#" />
          </IconButton>
        </Tooltip>
      )}
      <Menu
        sx={{ mt: "45px" }}
        id="menu-appbar"
        anchorEl={avatarEl}
        anchorOrigin={{
          vertical: "top",
          horizontal: "right",
        }}
        keepMounted
        transformOrigin={{
          vertical: "top",
          horizontal: "right",
        }}
        open={Boolean(avatarEl)}
        onClose={() => setAvatarEl(null)}
      >
        {whoami && (
          <>
            <MenuItem disabled>Hi, @{whoami.sub}!</MenuItem>
            <Divider />
            <MenuItem href="/logout" component="a">
              Logout
            </MenuItem>
          </>
        )}
        {!whoami && (
          <MenuItem href="/login" component="a">
            Login
          </MenuItem>
        )}
      </Menu>
    </>
  );
};

function App() {
  return (
    <PageWrapper>
      <Box
        sx={{
          display: "flex",
          flexDirection: "row",
          width: "100%",
          alignItems: "center",
          mb: 1,
        }}
      >
        <Typography
          variant="h4"
          component="div"
          textAlign="center"
          sx={{ flexGrow: 1 }}
        >
          Fediverse Auth
        </Typography>
        <UserInfo />
      </Box>

      <Typography sx={{ mb: 1 }}>
        This service is for providing generic OpenID support to other services.
      </Typography>

      <Typography>
        You can find my source <Link href={DocLinks.SOURCE}>here</Link>.
      </Typography>
    </PageWrapper>
  );
}

export default App;
