# Handoff

Handoff allows for third-party applications to initiate a login

## Security

* Handoff sessions **cannot** alter your account
* As the third-party app is already able to act on your behalf, this does not allow unauthorized services to act on your behalf
* Handoff sessions exist for a short amount of time and can only be used once

## Creating a handoff session

**This is a rundown of the process** but this specification is intended to be built upon by other projects and discovery methods (like the [fediverse.events-api](https://sc07.dev/fediverse.events/fediverse.events-api))

1. **Require user interaction** The user must initiate the intent to login, a good example would be clicking a button to open a service that requires Fediverse Auth (eg [Canvas](https://sc07.dev/sc07/canvas))
2. **Request the service metadata** The metadata can be fetched from `/.well-known/com.sc07.fediverse-auth`
3. **Check if Handoff is supported** Not all fediverse-auth instances support Handoff, if supported the metadata should have a key `handoff.enabled` set to `true`
4. **Send a direct message**
    * The metadata page gives the account you should send a DM to (on behalf of the user) at the `fediverse.account` key (eg `auth@auth.fediverse.events` -- note the lack of a prefixing `@`)
    * The message MUST contain a short and simple explaination of what the message is (eg `I am requesting a login code`)
    * The message MUST contain the handoff token returned by the metadata at the `handoff.token` key
    * The message SHOULD contain what software sent the message (eg `Sent by Mastodon for iOS`). This information is helpful to the user and helpful for the service runner to find misbehaving applications. Optional, but also suggested is including the version number (eg `Sent by Mastodon for iOS (1.1.1)`)
5. **Wait for the reply** After sending the direct message to the service account, the service will reply with a URL
6. **Open the URL for the user** that was sent in the reply message, **with a return URL appended as a query parameter** (eg `https://auth.fediverse.events/handoff/EXAMPLE-TOKEN` --> `https://auth.fediverse.events/handoff/EXAMPLE-TOKEN?return_uri=https%3A%2F%2Fcanvas.fediverse.events%2Fapi%2Flogin`)