declare module "express-session" {
  interface SessionData {
    user?: {
      sub: string;
      handle: `${string}@${string}`;
    };
    login?: {
      /**
       * - USERNAME: user should enter username now
       * - ENTER_CODE: user was sent code, they need to enter it
       * - SEND_CODE: user needs to make a post
       * - OIDC: open oidc [todo]
       */
      prompt: "USERNAME" | "ENTER_CODE" | "OIDC";
      instance: string;
      username?: string;
      session_id?: string;
      attempt: number;
    };
  }
}

export {};
