export type NodeInfo = NodeInfo1_0 | NodeInfo1_1 | NodeInfo2_0 | NodeInfo2_1;
export const SUPPORTED_NODEINFO_VERSIONS = ["1.0", "1.1", "2.0", "2.1"];
export const NODEINFO_SCHEMA_NAMESPACE =
  "http://nodeinfo.diaspora.software/ns/schema/";

/**
 * NodeInfo Usage
 *
 * This is the same between all the versions
 */
type NodeInfo_Usage = {
  users: {
    total: number;
    activeHalfyear: number;
    activeMonth: number;
  };
  localPosts: number;
  localComments: number;
};

/**
 * NodeInfo 1.0 specification
 *
 * @see https://nodeinfo.diaspora.software/schema.html
 */
type NodeInfo1_0 = {
  version: "1.0";
  software: {
    name: "diaspora" | "friendica" | "redmatrix";
    version: string;
  };
  protocols: {
    inbound: (
      | "buddycloud"
      | "diaspora"
      | "friendica"
      | "gnusocial"
      | "libertree"
      | "mediagoblin"
      | "pumpio"
      | "redmatrix"
      | "smtp"
      | "tent"
    )[];
    outbound: (
      | "buddycloud"
      | "diaspora"
      | "friendica"
      | "gnusocial"
      | "libertree"
      | "mediagoblin"
      | "pumpio"
      | "redmatrix"
      | "smtp"
      | "tent"
    )[];
  };
  services: {
    inbound: ("appnet" | "gnusocial" | "pumpio")[];
    outbound: (
      | "appnet"
      | "blogger"
      | "buddycloud"
      | "diaspora"
      | "dreamwidth"
      | "drupal"
      | "facebook"
      | "friendica"
      | "gnusocial"
      | "google"
      | "insanejournal"
      | "libertree"
      | "linkedin"
      | "livejournal"
      | "mediagoblin"
      | "myspace"
      | "pinterest"
      | "posterous"
      | "pumpio"
      | "redmatrix"
      | "smtp"
      | "tent"
      | "tumblr"
      | "twitter"
      | "wordpress"
      | "xmpp"
    )[];
  };
  openRegistrations: boolean;
  usage: NodeInfo_Usage;
  metadata: any;
};

/**
 * NodeInfo 1.1 specification
 *
 * @see https://nodeinfo.diaspora.software/schema.html
 */
type NodeInfo1_1 = {
  version: "1.1";
  software: {
    name: "diaspora" | "friendica" | "hubzilla" | "redmatrix";
    version: string;
  };
  protocols: {
    inbound: (
      | "buddycloud"
      | "diaspora"
      | "friendica"
      | "gnusocial"
      | "libertree"
      | "mediagoblin"
      | "pumpio"
      | "redmatrix"
      | "smtp"
      | "tent"
      | "zot"
    )[];
    outbound: (
      | "buddycloud"
      | "diaspora"
      | "friendica"
      | "gnusocial"
      | "libertree"
      | "mediagoblin"
      | "pumpio"
      | "redmatrix"
      | "smtp"
      | "tent"
      | "zot"
    )[];
  };
  services: {
    inbound: ("appnet" | "gnusocial" | "pumpio")[];
    outbound: (
      | "appnet"
      | "blogger"
      | "buddycloud"
      | "diaspora"
      | "dreamwidth"
      | "drupal"
      | "facebook"
      | "friendica"
      | "gnusocial"
      | "google"
      | "insanejournal"
      | "libertree"
      | "linkedin"
      | "livejournal"
      | "mediagoblin"
      | "myspace"
      | "pinterest"
      | "posterous"
      | "pumpio"
      | "redmatrix"
      | "smtp"
      | "tent"
      | "tumblr"
      | "twitter"
      | "wordpress"
      | "xmpp"
    )[];
  };
  openRegistrations: boolean;
  usage: NodeInfo_Usage;
  metadata: any;
};

/**
 * NodeInfo 2.0 specification
 *
 * @see https://nodeinfo.diaspora.software/schema.html
 */
type NodeInfo2_0 = {
  version: "2.0";
  software: {
    name: string;
    version: string;
  };
  protocols: (
    | "activitypub"
    | "buddycloud"
    | "dfrn"
    | "diaspora"
    | "libertree"
    | "ostatus"
    | "pumpio"
    | "tent"
    | "xmpp"
    | "zot"
  )[];
  services: {
    inbound: (
      | "atom1.0"
      | "gnusocial"
      | "imap"
      | "pnut"
      | "pop3"
      | "pumpio"
      | "rss2.0"
      | "twitter"
    )[];
    outbound: (
      | "atom1.0"
      | "blogger"
      | "buddycloud"
      | "diaspora"
      | "dreamwidth"
      | "drupal"
      | "facebook"
      | "friendica"
      | "gnusocial"
      | "google"
      | "insanejournal"
      | "libertree"
      | "linkedin"
      | "livejournal"
      | "mediagoblin"
      | "myspace"
      | "pinterest"
      | "pnut"
      | "posterous"
      | "pumpio"
      | "redmatrix"
      | "rss2.0"
      | "smtp"
      | "tent"
      | "tumblr"
      | "twitter"
      | "wordpress"
      | "xmpp"
    )[];
  };
  openRegistrations: boolean;
  usage: NodeInfo_Usage;
  metadata: any;
};

/**
 * NodeInfo 2.1 specification
 *
 * @see https://nodeinfo.diaspora.software/schema.html
 */
type NodeInfo2_1 = {
  version: "2.1";
  software: {
    name: string;
    version: string;
    repository?: string;
    homepage?: string;
  };
  protocols: (
    | "activitypub"
    | "buddycloud"
    | "dfrn"
    | "diaspora"
    | "libertree"
    | "ostatus"
    | "pumpio"
    | "tent"
    | "xmpp"
    | "zot"
  )[];
  services: {
    inbound: (
      | "atom1.0"
      | "gnusocial"
      | "imap"
      | "pnut"
      | "pop3"
      | "pumpio"
      | "rss2.0"
      | "twitter"
    )[];
    outbound: (
      | "atom1.0"
      | "blogger"
      | "buddycloud"
      | "diaspora"
      | "dreamwidth"
      | "drupal"
      | "facebook"
      | "friendica"
      | "gnusocial"
      | "google"
      | "insanejournal"
      | "libertree"
      | "linkedin"
      | "livejournal"
      | "mediagoblin"
      | "myspace"
      | "pinterest"
      | "pnut"
      | "posterous"
      | "pumpio"
      | "redmatrix"
      | "rss2.0"
      | "smtp"
      | "tent"
      | "tumblr"
      | "twitter"
      | "wordpress"
      | "xmpp"
    )[];
  };
  openRegistrations: boolean;
  usage: NodeInfo_Usage;
  metadata: any;
};
