declare global {
  namespace NodeJS {
    interface ProcessEnv {
      NODE_ENV: "development" | "production";
      DATABASE_URL: string;
      REDIS_URI: string;
      SESSION_SECRET: string;
      PORT: string;

      OIDC_ISSUER: string;
      SERVICE_NAME: string;
      VERSION?: string;
      NODE_TYPE?: "worker";

      /**
       * If provided, enables the admin API
       */
      ADMIN_TOKEN?: string;
      OIDC_JWK_KEYS_FILE?: string;
      OIDC_COOKIE_KEYS_FILE?: string;
      OIDC_REGISTRATION_TOKEN?: string;
      USE_INSECURE?: string;

      SHADOW_HOST?: string;
      SHADOW_TOKEN?: string;

      BYPASS_CODE_VERIFICATION?: string;
      /**
       * Trust all proxies while in development
       */
      DEV_TRUST_PROXIES?: string;

      HANDOFF_TOKEN?: string;
    }
  }
}

export {};
