import { OidcTypes } from "../lib/adapter.js";
import { prisma } from "../lib/prisma.js";

const client = {
  client_id: "dev",
  client_secret: "dev",
  grant_types: ["authorization_code"],
  subject_type: "public",
  redirect_uris: [
    "http://localhost:3000",
    "http://localhost:8008/_synapse/client/oidc/callback",
  ],
  response_types: ["code"],
  application_type: "web",
  require_auth_time: false,
  client_id_issued_at: Date.now(),
  client_secret_expires_at: 0,
  post_logout_redirect_uris: [],
  token_endpoint_auth_method: "client_secret_basic",
  id_token_signed_response_alg: "RS256",
  require_pushed_authorization_requests: false,
};

console.log("creating or upserting dev client...");

prisma.oidcModel
  .upsert({
    where: {
      id: client.client_id,
    },
    create: {
      id: client.client_id,
      type: OidcTypes["Client"],
      payload: client,
    },
    update: {
      payload: client,
    },
  })
  .then(() => {
    console.log("created/upserted dev client");
  })
  .catch((e) => {
    console.error(e);
  });
