import path from "node:path";
import type Express from "express";
import fs from "node:fs";

export class ReactUtils<T = unknown> {
  private static fileContent: string;

  static get INDEX_PATH() {
    if (process.env.SERVE_FRONTEND) {
      return path.join(process.env.SERVE_FRONTEND, "index.html");
    }

    return null;
  }

  static get FILE_CONTENT() {
    if (!this.INDEX_PATH) throw new Error("SERVE_FRONTEND is not set");
    if (typeof this.fileContent === "undefined")
      this.fileContent = fs.readFileSync(this.INDEX_PATH, "utf8");

    return this.fileContent;
  }

  static render(req: Express.Request, res: Express.Response, data?: any) {
    if ("x-vite-middleware" in req.headers) {
      res.json({ data });
      return;
    }

    const INDEX_PATH = ReactUtils.INDEX_PATH;
    if (!INDEX_PATH) throw new Error("SERVE_FRONTEND is not set");

    if (typeof data === "undefined") {
      res.sendFile(INDEX_PATH);
      return;
    }

    res
      .contentType("html")
      .send(
        ReactUtils.FILE_CONTENT.replace(
          `</body>`,
          `<script id="ss-data" type="application/json">${JSON.stringify(
            data
          )}</script>`
        )
      );
  }

  constructor(private req: Express.Request, private res: Express.Response) {}

  render(data?: T) {
    return ReactUtils.render(this.req, this.res, data);
  }
}
