import {
  ActivityTransformer,
  getDefaultActivityTransformers,
} from "@fedify/fedify";

const toDehydrator: ActivityTransformer<void> = (activity, ctx) => {
  // dehydrate {to} to just IDs because lemmy rejects the message otherwise
  // @see https://github.com/LemmyNet/lemmy/blob/ed5a3831aa3ac10c9e0de6b70a7df282c94fcdb3/crates/apub/src/protocol/activities/create_or_update/private_message.rs#L15
  if (activity.toIds.length < 1) return activity;

  return activity.clone({
    tos: activity.toIds,
  });
};

export const FedifyTransformers: readonly ActivityTransformer<void>[] = [
  ...getDefaultActivityTransformers(),
  toDehydrator,
];
