import { Router } from "express";
import { prisma } from "./prisma.js";

const app = Router();

app.use((req, res, next) => {
  if (!process.env.ADMIN_TOKEN) {
    return res.status(500).send("This should not happen");
  }

  if (req.headers.authorization !== "Bearer " + process.env.ADMIN_TOKEN) {
    return res.status(403).send("Unauthorized");
  }

  next();
});

app.get("/status", async (req, res) => {
  const completed = await prisma.fediverseUser.count({
    where: {
      objectId: { not: null },
    },
  });
  const total = await prisma.fediverseUser.count();
  const errored = await prisma.fediverseUser.count({
    where: {
      error: true,
    },
  });
  res.json({ completed, total, errored });
});

/**
 * Queue up AP handles to be fetched
 * @body `${string}@${string}`[]
 */
app.post("/batch_get_object", async (req, res) => {
  if (!Array.isArray(req.body) || typeof req.body[0] !== "string") {
    res.status(400).send("Body is not a string[]");
    return;
  }

  const _logs: string[] = [];

  const log = (msg: string) => {
    console.log("/api/admin/batch_get_object:", msg);
    _logs.push(msg);
  };

  for (const handle of req.body) {
    if (typeof handle !== "string" || handle.indexOf("@") === -1) {
      log(`Handle (${handle}) is not valid`);
      continue;
    }

    const exist = await prisma.fediverseUser.findFirst({
      where: {
        handle,
      },
    });

    if (!exist) {
      await prisma.fediverseUser.create({
        data: {
          handle,
        },
      });
    } else {
      log(`Handle (${handle}) already exists`);
    }
  }

  res.json({
    logs: _logs,
  });
});

export const APIAdminRouter = app;
