import { Router } from "express";
import { HandoffSession } from "../controllers/HandoffSession.js";
import { ReactUtils } from "../lib/react.js";
import { APub } from "../lib/apub/utils.js";

export const router = Router();

type Data =
  | { state: "NOT_FOUND" }
  | { state: "MISSING_RETURN" | "INVALID_RETURN" }
  | { state: "INTERNAL_PROFILE_ERROR" };

router.get("/:id", async (req, res) => {
  const session = await HandoffSession.get(req.params.id);
  const Injector = new ReactUtils<Data>(req, res);

  if (!session) {
    res.status(404);
    Injector.render({ state: "NOT_FOUND" });
    return;
  }

  const { return_uri } = req.query;

  if (!return_uri || typeof return_uri !== "string") {
    res.status(400);
    Injector.render({ state: "MISSING_RETURN" });
    return;
  }

  try {
    const url = new URL(return_uri);
    if (!url.protocol.startsWith("https")) throw new Error();
  } catch (e) {
    console.log(e);
    res.status(400);
    Injector.render({ state: "INVALID_RETURN" });
    return;
  }

  const profile = await APub.buildProfile(session.userId);
  if (!profile) {
    res.status(500);
    Injector.render({ state: "INTERNAL_PROFILE_ERROR" });
    return;
  }

  await session.destroy();

  req.session.user = {
    sub: profile.sub,
    handle: profile.preferred_username as any,
  };
  req.session.login = undefined;
  req.session.save(() => {
    res.redirect(return_uri);
  });
});
