import { HandoffActivityPub } from "./activitypub.js";
import { router } from "./router.js";

export class Handoff {
  private static instance: Handoff;

  static canEnable() {
    return !!process.env.HANDOFF_TOKEN;
  }

  static get() {
    if (!process.env.HANDOFF_TOKEN)
      throw new Error("HANDOFF_TOKEN not set, cannot use Handoff");

    if (!this.canEnable())
      throw new Error(
        "This should never occur, developer missed adding description throw above this line"
      );

    if (!this.instance) this.instance = new Handoff();

    return this.instance;
  }

  private constructor() {}

  static readonly HANDOFF_TOKEN = process.env.HANDOFF_TOKEN!;
  readonly activitypub = new HandoffActivityPub();
  readonly router = router;
}
