import { HandoffSession as DBHandoffSession } from "@prisma/client";
import { prisma } from "../lib/prisma.js";

export class HandoffSession {
  static async create(userId: string): Promise<HandoffSession> {
    // 15 minutes
    const expiresAt = new Date(Date.now() + 1000 * 60 * 15);

    const session = await prisma.handoffSession.create({
      data: {
        userId,
        expiresAt,
      },
    });

    return new HandoffSession(session);
  }
  static async getExpired() {
    const sessions = await prisma.handoffSession.findMany({
      where: {
        expiresAt: {
          lte: new Date(),
        },
      },
    });
    return sessions.map((d) => new HandoffSession(d));
  }
  static async get(id: string) {
    const session = await prisma.handoffSession.findFirst({
      where: {
        id,
        expiresAt: { gt: new Date() },
      },
    });

    if (!session) return null;

    return new HandoffSession(session);
  }

  private _id: string;
  private _userId: string;
  private _createdAt: Date;
  private _updatedAt: Date;
  private _expiresAt: Date;

  private constructor(session: DBHandoffSession) {
    this._id = session.id;
    this._userId = session.userId;
    this._createdAt = session.createdAt;
    this._updatedAt = session.updatedAt;
    this._expiresAt = session.expiresAt;
  }

  get id() {
    return this._id;
  }

  get userId() {
    return this._userId;
  }

  get createdAt() {
    return this._createdAt;
  }

  get updatedAt() {
    return this._updatedAt;
  }

  get expiresAt() {
    return this._expiresAt;
  }

  getURL() {
    return new URL(`/handoff/${this._id}`, process.env.OIDC_ISSUER);
  }

  destroy() {
    return prisma.handoffSession.delete({ where: { id: this._id } });
  }
}
