/*
  Warnings:

  - You are about to drop the column `mode` on the `AuthSession` table. All the data in the column will be lost.
  - A unique constraint covering the columns `[objectId]` on the table `AuthSession` will be added. If there are existing duplicate values, this will fail.
  - The required column `objectId` was added to the `AuthSession` table with a prisma-level default value. This is not possible if the table is not empty. Please add this column as optional, then populate it before making it required.

*/
-- AlterTable
ALTER TABLE "AuthSession" DROP COLUMN "mode",
ADD COLUMN     "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
ADD COLUMN     "expiresAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
ADD COLUMN     "objectId" TEXT NOT NULL;

-- CreateTable
CREATE TABLE "FediverseKeyPair" (
    "id" TEXT NOT NULL,
    "keyType" TEXT NOT NULL,
    "value" TEXT NOT NULL,

    CONSTRAINT "FediverseKeyPair_pkey" PRIMARY KEY ("id")
);

-- CreateIndex
CREATE UNIQUE INDEX "AuthSession_objectId_key" ON "AuthSession"("objectId");
