import * as openid from "openid-client";

class OpenID_ {
  config: openid.Configuration = {} as any;

  async setup() {
    if (process.env.INHIBIT_LOGIN) {
      // eslint-disable-next-line no-console
      console.warn(
        "OpenID is not setup; INHIBIT_LOGIN environment variable set! Proceed with caution!"
      );
      return;
    }

    const { AUTH_ENDPOINT, AUTH_CLIENT, AUTH_SECRET } = process.env;

    this.config = await openid.discovery(new URL(AUTH_ENDPOINT), AUTH_CLIENT, {
      client_secret: AUTH_SECRET,
    });
  }

  getRedirectUrl() {
    return process.env.OIDC_CALLBACK_HOST + "/api/callback";
  }

  getAuthorizationURL() {
    return openid
      .buildAuthorizationUrl(this.config, {
        redirect_uri: this.getRedirectUrl(),
        prompt: "consent",
        scope: "openid instance",
      })
      .toString();
  }

  exchangeToken(relativePath: string) {
    return openid.authorizationCodeGrant(
      this.config,
      new URL(relativePath, process.env.OIDC_CALLBACK_HOST)
    );
  }

  userInfo<Data extends object = object>(
    accessToken: string,
    expectedSub: string
  ): Promise<openid.UserInfoResponse & Data> {
    return openid.fetchUserInfo(this.config, accessToken, expectedSub) as any;
  }
}

export const OpenID = new OpenID_();
