import "./lib/sentry";
import React from "react";
import { createRoot } from "react-dom/client";
import { NextUIProvider } from "@nextui-org/react";
import { ThemeProvider } from "next-themes";
import App from "./components/App";

import * as Sentry from "@sentry/react";

let ErrorBoundary = ({ children }: React.PropsWithChildren) => <>{children}</>;

if (__SENTRY_DSN__) {
  ErrorBoundary = ({ children }) => {
    return <Sentry.ErrorBoundary showDialog>{children}</Sentry.ErrorBoundary>;
  };
}

const root = createRoot(document.getElementById("root")!);
root.render(
  <React.StrictMode>
    <ErrorBoundary>
      <NextUIProvider>
        <ThemeProvider attribute="class" defaultTheme="system">
          <div className="w-screen h-screen bg-[#ddd] dark:bg-[#060606]">
            <App />
          </div>
        </ThemeProvider>
      </NextUIProvider>
    </ErrorBoundary>
  </React.StrictMode>
);
