import { defineConfig, loadEnv } from "vite";
import react from "@vitejs/plugin-react";
import * as child from "child_process";
import { sentryVitePlugin } from "@sentry/vite-plugin";

const commitHash = child
  .execSync("git rev-parse --short HEAD")
  .toString()
  .trim();

export default defineConfig(({ mode }) => {
  process.env = { ...process.env, ...loadEnv(mode, process.cwd(), "") };

  return {
    root: "src",
    envDir: "..",
    build: {
      outDir: "../dist",
      emptyOutDir: true,
      sourcemap: true,
    },
    plugins: [
      react({
        include: "**/*.{jsx,tsx}",
      }),
      process.env.SENTRY_DSN ? sentryVitePlugin() : undefined,
    ],
    define: {
      __COMMIT_HASH__: JSON.stringify(commitHash),
      __SENTRY_DSN__: JSON.stringify(process.env.SENTRY_DSN) || null,
    },
    server: {
      proxy: {
        "/api": "http://localhost:3000",
        "/socket.io": {
          target: "ws://localhost:3000",
          ws: true,
        },
      },
    },
  };
});
