---
title: Sentry
---

The frontend & backend are both equiped with [Sentry](https://sentry.io) error reporting to aid with debugging.
You can selfhost Sentry [using this guide](https://develop.sentry.dev/self-hosted/).

**Note:** if the Sentry DSN environment variable isn't present, Sentry will not be initialized and therefore will not send any information

**Note:** if the PROJECT, ORG, URL, AUTH_TOKEN is not provided sourcemaps will not be uploaded at build time

**Environment Variable Keys:**

- `build` used during the build phase (usually `npm run build`)
- `dev` used during development (usually `npm run dev`)
- `runtime` used during runtime/deployment

# Docker Building

Docker builds will take the build environment variables as `--build-arg`s, with a couple changes

- Frontend's `SENTRY_DSN` & `SENTRY_PROJECT` are renamed to `CLIENT_SENTRY_DSN` & `CLIENT_SENTRY_PROJECT` respectfully
- Backend's `SENTRY_DSN` & `SENTRY_PROJECT` are renamed to `SERVER_SENTRY_DSN` & `SERVER_SENTRY_PROJECT` respectfully

As each project has to be separated within Sentry, the DSN & project IDs will be different

_See `/Dockerfile` for how they're used_<br />
_See `/.gitlab/ci/deploy.yml` for an example of a `docker build` with the arguments_

# Frontend

With how Vite builds, the environment variables will be used during the build stage to generate the client

## Environment

| Environment         | Uses       | Description                                                                                    |
| ------------------- | ---------- | ---------------------------------------------------------------------------------------------- |
| `SENTRY_DSN`        | build, dev | Frontend DSN, baked into the client as `__SENTRY_DSN__` (see `packages/client/vite.config.js`) |
| `SENTRY_PROJECT`    | build      | Project ID, used to send sourcemaps to Sentry                                                  |
| `SENTRY_ORG`        | build      | Project organization ID, used to send sourcemaps                                               |
| `SENTRY_URL`        | build      | Sentry hostname (eg `https://sentry.io`)                                                       |
| `SENTRY_AUTH_TOKEN` | build      | Auth token for sending the sourcemaps                                                          |

# Backend

## Environment

| Environment                 | Uses                | Description                                                     |
| --------------------------- | ------------------- | --------------------------------------------------------------- |
| `SENTRY_DSN`                | build, runtime, dev | Backend DSN                                                     |
| `SENTRY_TUNNEL_PROJECT_IDS` | runtime, dev        | Comma-separated list of project IDs to allow through the tunnel |
| `SENTRY_PROJECT`            | build               | Project ID, used to send sourcemaps                             |
| `SENTRY_ORG`                | build               | Project organization ID, used to send sourcemaps                |
| `SENTRY_URL`                | build               | Sentry hostname (eg `https://sentry.io`)                        |
| `SENTRY_AUTH_TOKEN`         | build               | Auth token for sending sourcemaps                               |
| `SENTRY_ENVIRONMENT`        | runtime             | Passed to Sentry to log what environment we're running in       |
