/**
 * Create enum from array of strings
 *
 * @param values
 * @returns
 */
export const createEnum = <T extends string>(values: T[]): { [k in T]: k } => {
  const ret: { [k in T]: k } = {} as any;

  for (const val of values) {
    ret[val] = val;
  }

  return ret;
};

export type ConditionalPromise<
  T,
  UsePromise extends boolean = false,
> = UsePromise extends true ? Promise<T> : UsePromise extends false ? T : never;
