import * as Sentry from "@sentry/node";

import { LONG_HASH } from "../const";

if (process.env.SENTRY_DSN) {
  // only initialize sentry if environment variable is set

  Sentry.init({
    dsn: process.env.SENTRY_DSN,
    release: LONG_HASH,
    environment: process.env.SENTRY_ENVIRONMENT ?? "development",

    tracesSampleRate: 1.0,
  });

  // ignore because this is related to error handling
  // eslint-disable-next-line no-console
  console.log("Sentry init with", process.env.SENTRY_DSN);
}
