/**
 * https://git.sc07.company/fediverse.events/canvas-countdown-website
 */

const EVENT_START = new Date(1752292800000); // midnight 7/12/2024 4:00am UTC

const getCountdown = () => {
  // date math always confuses me...
  // https://stackoverflow.com/a/7709819

  const now = Date.now();
  const ms = EVENT_START - now;
  const days = Math.floor(ms / (1000 * 60 * 60 * 24));
  const hours = Math.floor((ms % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
  const minutes = Math.floor(
    ((ms % (1000 * 60 * 60 * 24)) % (1000 * 60 * 60)) / (1000 * 60)
  );
  const seconds = Math.round(
    (((ms % (1000 * 60 * 60 * 24)) % (1000 * 60 * 60)) % (1000 * 60)) / 1000
  );

  return [days, hours, minutes, seconds];
};

const updateTime = () => {
  const $countdown = document.getElementById("countdown");
  const [days, hours, minutes, seconds] = getCountdown();

  $countdown.innerText = [
    days && days + "d",
    hours && hours + "h",
    minutes && minutes + "m",
    seconds && seconds + "s",
  ]
    .filter((a) => a)
    .join(" ");

  $countdown.title = `${days} days ${hours} hours ${minutes} minutes ${seconds} seconds`;
};

setInterval(updateTime, 1000);
updateTime();
